/** @file   parametertable.cpp
 * @brief   Implementation of ParameterTable - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "parametertable.h"

using std::map;
using std::string;

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
ParameterTable::ParameterTable()
{
}



/** A copy constructor.
 */
ParameterTable::ParameterTable( const ParameterTable& rO ) :
  m_parameters( rO.m_parameters )
{
}


/** Destructor
 */
ParameterTable::~ParameterTable()
{
}



/** An assignment operator
 */
ParameterTable& ParameterTable::operator = ( const ParameterTable& rO )
{
  if ( this != &rO ) {
    m_parameters = rO.m_parameters;
  }
  return *this;
}




///
/// Public methods
/// ==============

/** Adds the given parameter to this table.
 */
void ParameterTable::addParameter( const string& parKey, const string& parValue )
{
  m_parameters[ parKey ] = parValue;
}



///
/// Getter methods
/// ==============

/** Returns the requested parameter.
 */
string ParameterTable::get( const std::string& parKey ) const
{
  map<string,string>::const_iterator it = m_parameters.find( parKey );
  if ( it == m_parameters.end() ) {
    return string( "" );
  }
  return it->second;
}



/** Converts the parameter to integer and returns it.
 */
int ParameterTable::getInt( const string& parKey ) const
{
  return atoi( this->get( parKey ).c_str() );
}



/** Converts the parameter to float and returns it.
 */
float ParameterTable::getFloat( const string& parKey ) const
{
  return atof( this->get( parKey ).c_str() );
}



/** Returns the number of parameters
 */
int ParameterTable::size() const
{
  return m_parameters.size();
}



/** Tells if there is the given parameter.
 */
bool ParameterTable::exists( const string& parKey ) const
{
  map<string,string>::const_iterator it = m_parameters.find( parKey );
  if ( it == m_parameters.end() ) {
    return false;
  }
  return true;
}

///
/// Private or Protected methods
/// ============================

} // end of namespace
